//WPFractalsMod01.fsh
//https://glslsandbox.com/e#77887.0
// Licence CC0
// Adapted, trivialy, for use in VGHD player
uniform float u_Elapsed; // The time elapsed in seconds since the beginning of the scene.
uniform vec2 u_WindowSize;  // This is the dimensions of the viewport.
// Use defines here rather than edit the body of the code.

#define iTime u_Elapsed
#define iResolution u_WindowSize

/////////////////////////////////////////////////////////////////////////////////
uniform sampler2D iChannel0;






 // Original shader from: https://www.shadertoy.com/view/Nl3SWM


#ifdef GL_ES
precision mediump float;
#endif

// glslsandbox uniforms
//uniform float iTime;
//uniform vec2 iResolution;

// shadertoy emulation
//float iTime = 0.;
//#define iResolution u_WindowSize;

// --------[ Original ShaderToy begins here ]---------- //
// magicBox by dgreensp o_O => https://www.shadertoy.com/view/4ljGDd

#define time (iTime*0.19 + iTime*0.21)
#define seed floor(time)
#define magic (Hash(seed) * 0.5 + inversesqrt(fract(time))*0.002 + 0.5)
#define super (Hash(seed + 1.0) + 1.5)
#define amaze (Hash(seed + 2.0)*0.7 + 0.3)

float Hash(float h) {
    return fract(sin(h) * 43758.5453);
}

void main( void )
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    vec2 uv = gl_FragCoord.xy/iResolution.y - 0.5;
    uv.x *= iResolution.x/iResolution.y;
    uv *= 1.4;
	vec3 col;

    uv = 0.5 - fract(uv);
    float lL = length(uv);
    
    for (float i=0.0; i<5.0; i++) {
        uv = abs(uv) / pow(lL, super) - magic;
        float nL = length(clamp(uv, - amaze, 1.0));
        col = max(col, abs(nL - lL));
        col *= 1.0 - vec3( Hash(seed+0.1+i), Hash(seed+0.2+i), Hash(seed+0.3)) * 0.25;
        lL = nL;
    }

    gl_FragColor = vec4(col, 1.0);
}
// --------[ Original ShaderToy ends here ]---------- //

//#undef time

//void main(void)
//{//
   // iTime = time;//
   // mainImage(gl_FragColor, gl_FragCoord.xy);//
//}//